import { StateNode } from "@tldraw/editor";
import { updateHoveredShapeId } from "../../../tools/selection-logic/updateHoveredShapeId.mjs";
class Idle extends StateNode {
  static id = "idle";
  onPointerMove = (info) => {
    switch (info.target) {
      case "shape":
      case "canvas": {
        updateHoveredShapeId(this.editor);
      }
    }
  };
  onPointerDown = (info) => {
    this.parent.transition("pointing", info);
  };
  onEnter = () => {
    this.editor.setCursor({ type: "cross", rotation: 0 });
  };
  onExit = () => {
    updateHoveredShapeId.cancel();
  };
  onKeyDown = (info) => {
    if (info.key === "Enter") {
      if (this.editor.getInstanceState().isReadonly) return null;
      const onlySelectedShape = this.editor.getOnlySelectedShape();
      if (onlySelectedShape && this.editor.getShapeUtil(onlySelectedShape).canEdit(onlySelectedShape)) {
        this.editor.setCurrentTool("select");
        this.editor.setEditingShape(onlySelectedShape.id);
        this.editor.root.getCurrent()?.transition("editing_shape", {
          ...info,
          target: "shape",
          shape: onlySelectedShape
        });
      }
    }
  };
  onCancel = () => {
    this.editor.setCurrentTool("select");
  };
}
export {
  Idle
};
//# sourceMappingURL=Idle.mjs.map
